/*
 * PROGETTO MATURITA' 2017
 * THE CUBE - RETE DI SENSORI WIRELESS
 * CRIPPA M.    FUMAGALLI A.
 * PALERMO G.   VITULLO J.
 * TUTTI I DIRITTI RISERVATI
 * RINGRAZIAMENTO SPECIALE AL PROFESSOR VILLA V. - www.vincenzov.net -
 */

// Include function.c file
#include "MyFunction.h"
#include "mcc_generated_files/mcc.h"

long int id_tx;
unsigned char n [NAME_LENGTH];
unsigned char lettura_eeprom[EEPROM_LENGTH];
unsigned char id_saved[ID_LENGTH]; //Buffer contenente ID 

void main(void) {

    int counter;
    int addr;

    WDTCON = 0;

    SYSTEM_Initialize(); // Initialize the device
    configurePorts(); // Configurazione di tutte le periferiche

    //Controllo memoria EEPROM
    for (counter = 0, addr = EEPROM_START_ADDR; counter < EEPROM_LENGTH; counter++, addr++)
        lettura_eeprom[counter] = DATAEE_ReadByte(addr);

    if (lettura_eeprom[0] == 0xFF){  
        pairing:
        pairing(1);
    }
    else {
        for (counter = 0, addr = EEPROM_START_ADDR; counter < ID_LENGTH; counter++, addr++)
            id_saved[counter] = DATAEE_ReadByte(addr);

        memcpy(&(id_tx), id_saved, ID_LENGTH);

        for (counter = 0, addr = EEPROM_START_ADDR_2; counter < NAME_LENGTH; counter++, addr++)
            n[counter] = DATAEE_ReadByte(addr);
    }
    
    if (PORTBbits.RB0 == 0)
    {        
        for(counter = 0; counter < 50; counter++)
        {
            LATCbits.LATC7 = 1; // Turn on  RC7 pin
            DelayMS(50);
            LATCbits.LATC7 = 0; // Turn off RC7 pin
            DelayMS(50);
        }
        deleter();
        goto pairing;
    }

    INTERRUPT_GlobalInterruptHighEnable(); // Enable high priority global interrupts
    INTERRUPT_GlobalInterruptLowEnable(); // Enable low priority global interrupts.
    
    while (1) {

        WDTCON = 0;
        
        DelayMS(100);
        lettura();
        DelayMS(100);
        temperatura();
        
        //INVIA DECIMALI DA CONVERTIRE IN ASCII
        DelayMS(1000);
        
        CLRWDT(); // Restart the WDT
        WDTCON = 1; // Enable the WDT
        SLEEP();
    }           
}