#include "MyFunction.h"
#include "mcc_generated_files/mcc.h"

long int dato_i;
int temp;
int i = 0;
uint8_t readBuffer[10]; // Data from device will be read here
I2C2_MESSAGE_STATUS status = I2C2_MESSAGE_COMPLETE; // I2C status

unsigned char ack[BUFFERSIZE]; // Buffer ricevuto

struct frame {
    unsigned char Mytype;
    long int id_rx;
    char name[NAME_LENGTH];
    unsigned char sensor_type;
    char dato[DATA_LENGTH];
};

long int recive_id;
long int id_tx;
int i;
int cond;
unsigned char n [NAME_LENGTH];
unsigned char lettura_eeprom[EEPROM_LENGTH];
unsigned char id_saved[ID_LENGTH]; //Buffer contenente ID 

struct frame ack_rx;

/*long int pairing(unsigned char par) {

    int counter;
    int addr;
    int cond = 1;

    unsigned char data[BUFFERSIZE]; // Buffer trasmesso                        

    while (cond == 1) {

        unsigned char data[BUFFERSIZE]; // Buffer trasmesso                        

        for (i = 0; i < BUFFERSIZE; i++) // Preparazione del buffer da trasmettere
            data[i] = TYPE_HELLO;
        nrf24l01_write_tx_payload(data, BUFFERSIZE, true); // Trasmissione del buffer
        for (i = 0; i < BUFFERSIZE; i++) // cancellazione del buffer di ricezione
            ack[i] = 0;

        //wait until the packet has been sent or the maximum number of retries has been active
        while (!(nrf24l01_irq_pin_active() && (nrf24l01_irq_tx_ds_active() || nrf24l01_irq_max_rt_active())));

        nrf24l01_read_rx_payload(&(ack_rx.Mytype), BUFFERSIZE); // Ricezione del payload dell'ACK        
        DelayMS(1000);

        //copia dell'id e del nome ricevuti
        id_tx = ack_rx.id_rx;
        memcpy(id_saved, (unsigned char *) &id_tx, ID_LENGTH);

        if (ack_rx.Mytype == HELLO_ACK) {
            memcpy(n, ack_rx.name, NAME_LENGTH);

            //Copia del nome e dell'ID nella memoria EEPROM
            for (counter = 0, addr = EEPROM_START_ADDR; counter < ID_LENGTH; counter++, addr++)
                DATAEE_WriteByte(addr, id_saved[counter]);

            for (counter = 0, addr = EEPROM_START_ADDR_2; counter < NAME_LENGTH; counter++, addr++)
                DATAEE_WriteByte(addr, n[counter]);

            //Lettura test
            for (counter = 0, addr = EEPROM_START_ADDR; counter < 24; counter++, addr++)
                lettura_eeprom[counter] = DATAEE_ReadByte(addr);           

            cond = 2;
        } 
        else {
            for (counter = 0; counter < 10; counter++) {
                LATCbits.LATC7 = 1; // Turn on  RC7 pin
                DelayMS(50);
                LATCbits.LATC7 = 0; // Turn off  RC7 pin
                DelayMS(50);
                LATCbits.LATC6 = 1; // Turn on  RC6 pin
                DelayMS(50);
                LATCbits.LATC6 = 0; // Turn off  RC6 pin
                DelayMS(50);
            }           
            //while (!(nrf24l01_irq_pin_active() && (nrf24l01_irq_tx_ds_active() || nrf24l01_irq_max_rt_active())));
        }
        DelayMS(1000);
    }
    return 0;
}*/

long int pairing(cond) {

    int counter;
    int addr;

    for (counter = 0; counter < 10; counter++) {
        LATCbits.LATC6 = 1; // Turn on  RC6 pin
        DelayMS(50);
        LATCbits.LATC6 = 0; // Turn off RC6 pin
        DelayMS(50);
        LATCbits.LATC7 = 1; // Turn on  RC7 pin
        DelayMS(50);
        LATCbits.LATC7 = 0; // Turn off RC7 pin
        DelayMS(50);
    }

    while (cond == 1) {

        unsigned char data[BUFFERSIZE]; // Buffer trasmesso                        

        for (i = 0; i < BUFFERSIZE; i++) // Preparazione del buffer da trasmettere
            data[i] = TYPE_HELLO;
        nrf24l01_write_tx_payload(data, BUFFERSIZE, true); // Trasmissione del buffer
        for (i = 0; i < BUFFERSIZE; i++) // cancellazione del buffer di ricezione
            ack[i] = 0;

        //wait until the packet has been sent or the maximum number of retries has been active
        while (!(nrf24l01_irq_pin_active() && (nrf24l01_irq_tx_ds_active() || nrf24l01_irq_max_rt_active())));

        nrf24l01_read_rx_payload(&(ack_rx.Mytype), BUFFERSIZE); // Ricezione del payload dell'ACK        
        DelayMS(1000);

        //copia dell'id e del nome ricevuti
        id_tx = ack_rx.id_rx;
        memcpy(id_saved, (unsigned char *) &id_tx, ID_LENGTH);

        if (ack_rx.Mytype == HELLO_ACK) {
            memcpy(n, ack_rx.name, NAME_LENGTH);

            //Copia del nome e dell'ID nella memoria EEPROM
            for (counter = 0, addr = EEPROM_START_ADDR; counter < ID_LENGTH; counter++, addr++)
                DATAEE_WriteByte(addr, id_saved[counter]);

            for (counter = 0, addr = EEPROM_START_ADDR_2; counter < NAME_LENGTH; counter++, addr++)
                DATAEE_WriteByte(addr, n[counter]);

            //Lettura test
            for (counter = 0, addr = EEPROM_START_ADDR; counter < 24; counter++, addr++)
                lettura_eeprom[counter] = DATAEE_ReadByte(addr);

            cond = 2;
        }
        DelayMS(1000);
    }
    return 0;
}

void deleter(void) {

    struct frame delete_slave;

    nrf24l01_flush_tx(); // Pulizia del buffer di trasmissione di nRF24
    nrf24l01_irq_clear_all(); //Pulizia di tutti i flag di nRF24

    // Riempimento della struct da trasmettere
    delete_slave.Mytype = TYPE_DELETE;
    delete_slave.id_rx = id_tx;
    memcpy(delete_slave.name, 0, NAME_LENGTH);
    delete_slave.sensor_type = 0;
    memcpy(delete_slave.dato, 0, DATA_LENGTH);

    nrf24l01_write_tx_payload((unsigned char *) &delete_slave, BUFFERSIZE, true); // Trasmissione del buffer
    //wait until the packet has been sent or the maximum number of retries has been active
    while (!(nrf24l01_irq_pin_active() && (nrf24l01_irq_tx_ds_active() || nrf24l01_irq_max_rt_active())));
}

void temperatura(void) {

    struct frame temperatura_frame;
    char dato[7]; // Stringa che contiene il dato da trasmettere 

    nrf24l01_flush_tx(); // Pulizia del buffer di trasmissione di nRF24
    nrf24l01_irq_clear_all(); //Pulizia di tutti i flag di nRF24

    //dato_i = temp; // test
    sprintf(dato, "%06i", temp); // Pattern di zeri prima del dato effettivo
    i++;

    // Riempimento della struct da trasmettere
    temperatura_frame.Mytype = TYPE_DATA;
    temperatura_frame.id_rx = id_tx;
    memcpy(temperatura_frame.name, n, NAME_LENGTH);
    temperatura_frame.sensor_type = SENSOR_TEMP;
    memcpy(temperatura_frame.dato, dato, DATA_LENGTH);

    nrf24l01_write_tx_payload((unsigned char *) &temperatura_frame, BUFFERSIZE, true); // Trasmissione del buffer
    //wait until the packet has been sent or the maximum number of retries has been active
    while (!(nrf24l01_irq_pin_active() && (nrf24l01_irq_tx_ds_active() || nrf24l01_irq_max_rt_active())));
}

void lettura() {

    I2C2_MasterRead(readBuffer, 1, TC74_ADDR, &status); // read 1 byte from slave        
    temp = (int) readBuffer[0];
    DelayUS(300);

    //Ri-lettura per evitare che al primo invio di dati invii 0    
    I2C2_MasterRead(readBuffer, 1, TC74_ADDR, &status); // read 1 byte from slave        
    temp = (int) readBuffer[0];
    DelayUS(300);

}

void configurePorts(void) {

    /* Configurazione delle periferiche:

     * Clock a 64 MHz

     * Pin CE, CSN, IRQ

     * MSSP come SPI master

     * nRF24L01+

     */

#ifdef DEBUG 

    TRISCbits.RC0 = 0;

#endif



    OSCCON = 0x70; // 16 MHx x 4

    OSCTUNE = 0x40;

    while (PLLRDY == 0); // Attendo l'aggancio del PLL x4



    // Configurazione dei pin SPI

    ANSELC = 0; // Enable digital buffer

    TRISCbits.RC6 = 0; // Set CE pin as output

    LATCbits.LATC6 = 1; //set CE bit NON SERVIREBBE...

    TRISCbits.RC7 = 0; // Set CSN pin as output

    LATCbits.LATC7 = 1; //set CSN bit

    TRISCbits.RC2 = 1; // Set IRQ pin as input

    TRISCbits.RC4 = 1; // Set MISO pin as input SDI

    TRISCbits.RC3 = 0; // Set clock pin as output

    TRISCbits.RC5 = 0; // Set MOSI pin as output SDO



    SSP1CON1bits.SSPEN = 1; // Synchronous Serial Port Enable bit

    SSP1CON1bits.SSPM = 0b0010; // 0010  = SPI Master mode, clock = FOSC/64 = 1 MHz

    SSP1STATbits.CKE = 1; // 1 = Transmit occurs on transition from active to Idle clock state

    SSP1CON1bits.CKP = 0; // Idle state for clock is a low level

    SSP1STATbits.SMP = 0; // Input data sampled at middle of data output time



    nrf24l01_initialize_debug(false, BUFFERSIZE, true);

    // Imposto nRF24 cone trasmettitore, impostando la dimensione del buffer 

    // a la modalita auto-ack enabled



}