#include "delays.h"
#include "nrf24l01.h"
#include "stdio.h"
#include "string.h"

// define costanti
#define BUFFERSIZE 32       // Dimensione del buffer di trasmissione
#define TYPE_HELLO 69       // Tipo di frame che identifica il frame di 'hello'
#define TYPE_DATA 104       // Tipo di frame che identifica il frame per la trasmissione dei dati
#define HELLO_ACK 70        // Tipo di frame che identifica l'ack dell'hello
#define TYPE_DELETE 40      // Tipo di frame per eliminare il documento dal database
#define ID_LENGTH 4         // Lunghezza dell'ID
#define NAME_LENGTH 20      // Lunghezza del nome
#define DATA_LENGTH 6       // Lunghezza del dato
#define EEPROM_LENGTH 24    // Lunghezza ID e nome
#define SENSOR_TEMP 97 		// Identificatore del sensore temperatura durante la trasmissione
#define TC74_ADDR 0x48
#define EEPROM_START_ADDR 5 //CHIEDERE AL PROF
#define EEPROM_START_ADDR_2 9 //TEST


// function prototypes
void configurePorts(void); 
/*
 * Configurazione di tutte le periferiche
 */

long int pairing(int cond);
/*
 * Scopo: eseguire il pairing e collegare lo slave al master (assegna ID e nome)
 * Parametri: int cond ; condizione per uscire dal while e ritornare al mail
 *
 */

void deleter(void);
/*
 * Scopo: elimina il documento sul database
 * 
 */

void temperatura(void);
/*
 * Scopo: inviare il frame che contiene il dato della temperatura al master
 *
 */
                           
void lettura();
/*
 * Scopo: leggere la temperatura dal TC74
 */







long int read_temp_umidita();
/*
 * Scopo: leggere la temperatura e l'umidit dal sensore
 * Ritorno: un valore di tipo long int che indica la temperatura e l'umidit
 *
 */
 
long int read_gas(); // or boolean (true, false)
/*
 * Scopo: rileva la presenza o meno di gas dal sensore
 * Ritorno: un valore di tipo long int che indica la presenza o meno del gas
 *
 */ 